#ifdef GL_ES
precision mediump float;
#endif

const float TWO_PI = 6.28318530718;

// output from the vertex shader (fragment color and texture coordinates)
varying vec4 v_fragmentColor;
varying vec2 v_texCoord;


// uniform variables provided by the application
// uniform sampler2D CC_Texture0;
uniform float u_progress;
uniform float u_power;
uniform float u_fade_start;
uniform vec4 u_bounds;

float my_noise(float x, float y) {
	float value = u_progress * TWO_PI;

	return cos((x - value) +(y - value)) +
			sin((x * 0.1223 + value) - (y * 1.623 + value)) * 0.5;
}

float progress(float x, float min, float max) {
	return (x - min) / (max - min);
}

// const float BORDER_THICKNESS = 4.0;

// main shader function
void main() {
	//vec4 texel = texture2D(CC_Texture0, v_texCoord);
	vec2 uv = (gl_FragCoord.xy - u_bounds.xy) / u_bounds.zw;

	/** calculate the border distance
	  * 0.0 = no distance to border
	  * 1.0 = distance to border >= BORDER_THICKNESS
	  */
	/*
	vec2 tr_point = u_bounds.xy + u_bounds.zw;
	vec2 bl = smoothstep(u_bounds.xy, u_bounds.xy + BORDER_THICKNESS, gl_FragCoord.xy);
	vec2 tr = 1.0 - smoothstep(tr_point - BORDER_THICKNESS, tr_point, gl_FragCoord.xy);
	float outer = bl.x * bl.y * tr.x * tr.y;
	*/

	vec4 color = vec4(v_fragmentColor
						+ my_noise(gl_FragCoord.x * 0.012,
								   (gl_FragCoord.y * -0.03 * (50.0 / u_bounds[3])))
							* u_power);

	// fade out to border
	// color = mix(vec4(0.0), color, outer);
	if(uv.x > u_fade_start) {
		float prog = progress(uv.x, u_fade_start, 1.0);
		color = mix(color, vec4(0.0), prog * step(u_fade_start, uv.x));
	}

	gl_FragColor = vec4(color.rgb, color.a * v_fragmentColor.a);
}
